<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PageController; 
use App\Http\Controllers\DiamondController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
})->middleware(['verify.shopify'])->name('home');


 Route::post('/create-page', [PageController::class, 'createPage'])->name('create-page');

// Route::middleware('verify.shopify')->group(function () {
//     Route::post('/create-page', [PageController::class, 'createPage'])->name('create-page');
// });

Route::get('/diamonds', [PageController::class, 'getDiamonds'])->name('diamonds.get');

Route::get('/load-more-diamond', [DiamondController::class,'load_more_data'])->name('load_more_data');
Route::get('/diamond-details', [DiamondController::class,'diamond_details'])->name('diamond_details');
Route::get('/add-to-cart', [DiamondController::class,'add_to_cart'])->name('add_to_cart');
Route::get('/addToCart', [DiamondController::class,'addToCart'])->name('addToCart');

// Route::get('/load-more-diamond', [DiamondController::class,'load_more_data'])->middleware('cors');

// Route::get('load_more_data', [YourController::class, 'load_more_data'])->middleware('cors');

Route::post('/deletepr-page', [PageController::class, 'deletePage'])->name('deletepr-page');

use App\Http\Controllers\ShopifyWebhookController;
Route::post('/shop-redact',[ShopifyWebhookController::class,'handleShopRedact'])->middleware('auth.webhook')->name('shop.redact');
// Route::post('/webhook/shop-redact', [ShopifyWebhookController::class, 'handleShopRedact']);
Route::post('/webhook/customers-redact', [ShopifyWebhookController::class, 'handleCustomersRedact']);
Route::post('/webhook/customers-data-request', [ShopifyWebhookController::class, 'handleCustomersDataRequest']);


Route::get('/log', function () {
    \Log::info('Test log message');
});

Route::get('/diamond', function () {
    return view('diamond-page');
});
Route::get('/diamond-detail', function () {
    return view('diamond-detalis');
});

Route::get('/getProductPublications', [DiamondController::class,'getProductPublications'])->name('getProductPublications');

Route::get('/getSalesChannelIds', [DiamondController::class,'getSalesChannelIds'])->name('getSalesChannelIds');

