<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Diamond App User Guide</title>
    <style>
        /* Basic Reset */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            line-height: 1.6;
            background-color: #f8f8f8;
            color: #333;
            padding-bottom: 60px;
        }

        header {
            background-color: #333;
            color: #fff;
            padding: 20px 0;
            text-align: center;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        h1 {
            font-size: 36px;
            margin-bottom: 10px;
        }

        p {
            font-size: 16px;
            font-weight: 300;
        }

        .content {
            max-width: 1200px;
            margin: 30px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        section {
            margin-bottom: 40px;
        }

        h2 {
            font-size: 28px;
            color: #333;
            margin-bottom: 15px;
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
        }

        h3 {
            font-size: 22px;
            margin: 15px 0 10px;
            color: #5e5e5e;
        }

        ul {
            list-style: none;
            margin-left: 0;
            padding-left: 0;
        }

        li {
            margin-bottom: 12px;
            font-size: 16px;
        }

        .card {
            background-color: #f9f9f9;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }

        .card h4 {
            font-size: 20px;
            color: #333;
            margin-bottom: 10px;
        }

        .card p {
            font-size: 16px;
            color: #555;
        }

        a {
            color: #007BFF;
            text-decoration: none;
        }

        a:hover {
            text-decoration: underline;
        }

        footer {
            text-align: center;
            background-color: #333;
            color: #fff;
            padding: 20px 0;
            position: fixed;
            width: 100%;
            bottom: 0;
        }

        @media (max-width: 768px) {
            h1 {
                font-size: 28px;
            }

            .content {
                margin: 20px;
                padding: 15px;
            }

            section {
                margin-bottom: 30px;
            }

            footer {
                position: static;
                padding: 10px;
            }
        }
    </style>
</head>

<body>

    <header>
        <h1>Welcome to the Diamond App!</h1>
        <p>Your guide to finding the perfect diamond.</p>
    </header>

    <div class="content">
        <section id="getting-started">
            <h2>Getting Started</h2>
            <div class="card">
                <h4>App Installation</h4>
                <ul>
                    <li>1) Go to Shopify Admin > Online Store > Themes > Customize.</li>
                    <li>2) Enable Braintree Products App under App Embeds and click Save.</li>
                    <li>3) Click Create Diamond Page to create:
                        diamond-page (overview)
                        diamond-details (details).</li>
                </ul>
            </div>
        </section>

        <section id="key-features">
            <h2>Key Features</h2>
            <div class="card">
                <h3>1. Browse Diamonds</h3>
                <p>Explore our extensive collection of diamonds using the "Browse" tab. Use filters like carat, cut,
                    color, clarity, and price to refine your search.</p>
            </div>
            <div class="card">
                <h3>2. Search Diamonds</h3>
                <p>Use the search bar at the top of the app to find diamonds quickly. Enter keywords like "Round Cut,"
                    "1 Carat," or "GIA Certified" to locate specific diamonds.</p>
            </div>
            <div class="card">
                <h3>3. Diamond Filters</h3>
                <p>Our app offers a wide range of filters to help you find the perfect diamond. Here's how they work:
                </p>
                <ul>
                    <li><strong>Shape:</strong> Browse diamonds by shape, such as Round, Princess, Oval, Emerald, and
                        more.</li>
                    <li><strong>Carat:</strong> Select diamonds based on their size and weight, ranging from subtle to
                        statement-making.</li>
                    <li><strong>Price:</strong> Set your budget to view diamonds within your desired price range.</li>
                    <li><strong>Color:</strong> Filter diamonds from colorless (D) to light yellow (Z) on the GIA
                        grading scale.</li>
                    <li><strong>Clarity:</strong> Pick diamonds with clarity grades from Flawless (FL) to Included (I1,
                        I2), depending on your preferences.</li>
                    <li><strong>Cut:</strong> Choose the cut grade (e.g., Ideal, Excellent, Very Good) to ensure optimal
                        brilliance and sparkle.</li>
                    <li><strong>Lab Certification:</strong> Find diamonds certified by renowned organizations like GIA,
                        IGI, or HRD.</li>
                </ul>
            </div>
            <div class="card">
                <h3>4. Diamond Details</h3>
                <p>Tap on any diamond to view its full specifications, including Shape, Carat, Color, Clarity, Polish,
                    Symmetry, Fluorescence, Lab, and more. You can also view the 360-degree interactive image to explore
                    the diamond from all angles.</p>
            </div>
            <!--<div class="card">-->
            <!--    <h3>5. Diamond Comparison</h3>-->
            <!--    <p>Select multiple diamonds to compare their specifications side-by-side. Save comparisons for future-->
            <!--        reference.</p>-->
            <!--</div>-->
            <div class="card">
                <h3>5. Add to Cart</h3>
                <p>Once you find the perfect diamond, tap the "Add to Cart" button on the product page. Review your
                    selections in the "Cart" tab before proceeding to checkout.</p>
            </div>
        </section>

        <section id="customer-support">
            <h2>Customer Support</h2>
            <p>If you need any assistance, feel free to contact our support team:</p>
            <ul>
                <li><strong>Email:</strong> <a
                        href="mailto:praveen@braintreeproducts.com">praveen@braintreeproducts.com</a></li>
            </ul>
        </section>
    </div>

    <footer>
        <p>&copy; 2024 Diamond App. All Rights Reserved.</p>
    </footer>
</body>

</html><?php /**PATH /home/braintreeeasysof/public_html/braintree_app/resources/views/userguide.blade.php ENDPATH**/ ?>