<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="shopify-api-key" content="{{ env('SHOPIFY_API_KEY') }}">
    <title>{{ config('app.name', 'Laravel Shopify App') }}</title>

    <!-- App Bridge v3 -->
       <script src="https://cdn.shopify.com/shopifycloud/app-bridge.js"></script>
    <script src="https://unpkg.com/@shopify/app-bridge@3"></script>
    <script src="https://unpkg.com/@shopify/app-bridge@3.7.10/umd/index.js"></script>
</head>
<body>
    <main role="main">
        @yield('content')
    </main>

<script>
    const AppBridge = window['app-bridge'];
    const createApp = AppBridge.default;
    const Redirect = AppBridge.actions.Redirect;

    const app = createApp({
        apiKey: '{{ config('shopify-app.api_key') }}',
        host: '{{ request()->get("host") }}',
        forceRedirect: true
    });
    // console.log(app);
   
</script>

</body>
</html>