<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDiamondsTable extends Migration
{
    public function up()
    {
        Schema::create('tbl_diamond', function (Blueprint $table) {
            $table->id(); // Auto-incrementing ID
            $table->integer('diamond_id')->unique();
            $table->integer('stock_id');
            $table->boolean('availability')->default(true);
            $table->string('shape');
            $table->decimal('weight', 8, 2);
            $table->string('color');
            $table->string('grade');
            $table->string('cut');
            $table->string('polish');
            $table->string('symmetry');
            $table->string('fluorescence_int');
            $table->string('fluorescence_color');
            $table->string('measurements');
            $table->decimal('m_length', 8, 2);
            $table->decimal('m_width', 8, 2);
            $table->decimal('m_depth', 8, 2);
            $table->string('lab');
            $table->string('report_no')->nullable();
            $table->string('treatment')->nullable();
            $table->decimal('rapnet', 10, 2)->nullable();
            $table->decimal('rapnet_discount', 10, 2)->nullable();
            $table->decimal('cash_price', 10, 2)->nullable();
            $table->decimal('cash_price_discount', 10, 2)->nullable();
            $table->string('fancy_color')->nullable();
            $table->string('fancy_color_intensity')->nullable();
            $table->string('fancy_color_overtone')->nullable();
            $table->decimal('depth', 5, 2);
            $table->decimal('table_d', 5, 2);
            $table->string('girdle')->nullable();
            $table->string('girdle_thin')->nullable();
            $table->string('girdle_thick')->nullable();
            $table->string('girdle_perct')->nullable();
            $table->string('girdle_con')->nullable();
            $table->string('culet')->nullable();
            $table->string('culet_size')->nullable();
            $table->string('culet_con')->nullable();
            $table->decimal('crown_ht', 5, 2);
            $table->decimal('crown_angle', 5, 2);
            $table->decimal('pavillion_depth', 5, 2);
            $table->decimal('pavillion_angle', 5, 2);
            $table->text('insp')->nullable();
            $table->text('notes')->nullable();
            $table->string('country')->nullable();
            $table->string('state')->nullable();
            $table->string('city')->nullable();
            $table->boolean('is_match_pair_sep')->default(false);
            $table->string('pair_stock')->nullable();
            $table->boolean('allow_raplink_feed')->default(false);
            $table->boolean('parcel_stones')->default(false);
            $table->string('report_filename')->nullable();
            $table->string('diamond_image')->nullable();
            $table->string('diamond_video')->nullable();
            $table->string('sarine_loupe')->nullable();
            $table->string('trade_show')->nullable();
            $table->string('keytosymb')->nullable();
            $table->decimal('shade', 5, 2)->nullable();
            $table->string('star_len')->nullable();
            $table->string('center_inclusion')->nullable();
            $table->string('black_inclusion')->nullable();
            $table->string('milky')->nullable();
            $table->string('open_inclusion')->nullable();
            $table->text('member_comment')->nullable();
            $table->date('report_dt')->nullable();
            $table->string('report_type')->nullable();
            $table->string('lab_location')->nullable();
            $table->boolean('eye_clean')->default(false);
            $table->string('brand')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->timestamps();
            $table->unsignedBigInteger('edited_by')->nullable();
            $table->string('time_to_location')->nullable();
            $table->string('rap_seller')->nullable();
            $table->string('rap_seller_id')->nullable();
            $table->string('rap_seller_code')->nullable();
            $table->string('rap_diamond_id')->nullable();
            $table->unsignedBigInteger('vendor_id')->nullable();
            $table->string('diamond_type')->nullable();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tbl_diamond');
    }
}
