<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\View;
use App\Models\Diamond;

class PageController extends Controller
{
    // public function createPage(Request $request)
    // {
    //       $diamonds = Diamond::all();
          
    //     // Get user ID from the request, or default to 1 for testing
    //     $userId = $request->input('user_id', 1);
    //     $user = User::find($userId);

    //     // Check if user exists
    //     if (!$user) {
    //         return response()->json(['error' => 'User not found.'], 404);
    //     }

    //     // Render the Blade view to get the HTML content
    //     $bodyHtml = View::make('product_list')->render();

    //     // Prepare the data to send to Shopify
    //     $data = [
    //         'page' => [
    //             'title' => 'Warranty information',
    //             'body_html' => $bodyHtml,
    //         ]
    //     ];

    //     // Make the request to the Shopify API using the user's API method
    //     $response = $user->api()->rest('POST', '/admin/api/2024-01/pages.json', $data);

    //     // Handle the response
    //     if (isset($response['errors'])) {
    //         return response()->json($response['errors'], 400); // Error response
    //     }

    //     return response()->json($response['body'], 201); // Success response
    // }
    
    public function createPage(Request $request)
{
    $diamonds = Diamond::all();
    
    // Get user ID from the request, or default to 1 for testing
    $userId = $request->input('user_id', 1);
    $user = User::find($userId);

    // Check if user exists
    if (!$user) {
        return response()->json(['error' => 'User not found.'], 404);
    }

    // Render the Blade view and pass the diamonds data
    $bodyHtml = View::make('product_list', ['diamonds' => $diamonds])->render();

    // Prepare the data to send to Shopify
    $data = [
        'page' => [
            'title' => 'Warranty information',
            'body_html' => $bodyHtml,
        ]
    ];

    // Make the request to the Shopify API using the user's API method
    $response = $user->api()->rest('POST', '/admin/api/2024-01/pages.json', $data);

    // Handle the response
    if (isset($response['errors'])) {
        return response()->json($response['errors'], 400); // Error response
    }

    return response()->json($response['body'], 201); // Success response
}

}

