<?php

namespace App\Http\Controllers;

use App\Jobs\ShopRedactJob;
use App\Jobs\CustomersDataRequestJob;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class ShopifyWebhookController extends Controller
{
    /**
     * Handle the shop/redact webhook.
     *
     * @param Request $request
     * @return \Illuminate\Http\Response
     */
    public function handleShopRedact(Request $request)
    {
        $data = $request->all();
        $shopDomain = $data['shop_domain'];

        // Dispatch the job to handle the shop redact
        ShopRedactJob::dispatch($shopDomain, (object)$data);

        // Log webhook reception
        Log::info("Shop redact webhook received for shop domain: {$shopDomain}");

        return response()->json(['status' => 'success']);
    }

    /**
     * Handle the customers/redact webhook.
     *
     * @param Request $request
     * @return \Illuminate\Http\Response
     */
    public function handleCustomersRedact(Request $request)
    {
        $data = $request->all();
        $shopDomain = $data['shop_domain'];

        // Here you can process customer redaction if needed
        Log::info("Customers redact webhook received for shop domain: {$shopDomain}");

        return response()->json(['status' => 'success']);
    }

    /**
     * Handle the customers-data-request webhook.
     *
     * @param Request $request
     * @return \Illuminate\Http\Response
     */
    public function handleCustomersDataRequest(Request $request)
    {
        $data = $request->all();
        $shopDomain = $data['shop_domain'];

        // Dispatch the job to gather customer data
        CustomersDataRequestJob::dispatch($shopDomain, (object)$data);

        // Log webhook reception
        Log::info("Customers data request webhook received for shop domain: {$shopDomain}");

        return response()->json(['status' => 'success']);
    }
}
