<!DOCTYPE html>

<html lang="en">



<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Diamond App User Guide</title>

    <style>

        /* Basic Reset */

        * {

            margin: 0;

            padding: 0;

            box-sizing: border-box;

        }



        body {

            font-family: 'Arial', sans-serif;

            line-height: 1.6;

            background-color: #f8f8f8;

            color: #333;

            padding-bottom: 60px;

        }



        header {

            background-color: #333;

            color: #fff;

            padding: 20px 0;

            text-align: center;

            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);

        }



        h1 {

            font-size: 36px;

            margin-bottom: 10px;

        }



        p {

            font-size: 16px;

            font-weight: 300;

        }



        .content {

            max-width: 1200px;

            margin: 30px auto;

            padding: 20px;

            background-color: #fff;

            border-radius: 10px;

            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);

        }



        section {

            margin-bottom: 40px;

        }



        h2 {

            font-size: 28px;

            color: #333;

            margin-bottom: 15px;

            border-bottom: 2px solid #eee;

            padding-bottom: 10px;

        }



        h3 {

            font-size: 22px;

            margin: 15px 0 10px;

            color: #5e5e5e;

        }



        ul {

            list-style: none;

            margin-left: 0;

            padding-left: 0;

        }



        li {

            margin-bottom: 12px;

            font-size: 16px;

        }



        .card {

            background-color: #f9f9f9;

            padding: 20px;

            border-radius: 8px;

            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);

            margin-bottom: 20px;

        }



        .card h4 {

            font-size: 20px;

            color: #333;

            margin-bottom: 10px;

        }



        .card p {

            font-size: 16px;

            color: #555;

        }



        a {

            color: #007BFF;

            text-decoration: none;

        }



        a:hover {

            text-decoration: underline;

        }



        footer {

            text-align: center;

            background-color: #333;

            color: #fff;

            padding: 20px 0;

            position: fixed;

            width: 100%;

            bottom: 0;

        }



        @media (max-width: 768px) {

            h1 {

                font-size: 28px;

            }



            .content {

                margin: 20px;

                padding: 15px;

            }



            section {

                margin-bottom: 30px;

            }



            footer {

                position: static;

                padding: 10px;

            }

        }

    </style>

</head>



<body>



    <header>

        <h1>Welcome to the Diamond App!</h1>

        <p>Your guide to finding the perfect diamond.</p>

    </header>



    <div class="content">

        <section id="getting-started">

            <h2>Getting Started</h2>

            <div class="card">

                <h4>App Installation</h4>

                <ul>

                    <li>1) Go to Shopify Admin > Online Store > Themes > Customize.</li>

                    <li>2) Enable Braintree Products App under App Embeds and click Save.</li>

                    <li>3) Click Create Diamond Page to create:

                        diamond-page (overview)

                        diamond-details (details).</li>

                </ul>

            </div>

        </section>



        <section id="key-features">

            <h2>Key Features</h2>

            <div class="card">

                <h3>1. Browse Diamonds</h3>

                <p>Explore our extensive collection of diamonds using the "Browse" tab. Use filters like carat, cut,

                    color, clarity, and price to refine your search.</p>

            </div>

            <div class="card">

                <h3>2. Search Diamonds</h3>

                <p>Use the search bar at the top of the app to find diamonds quickly. Enter keywords like "Round Cut,"

                    "1 Carat," or "GIA Certified" to locate specific diamonds.</p>

            </div>

            <div class="card">

                <h3>3. Diamond Filters</h3>

                <p>Our app offers a wide range of filters to help you find the perfect diamond. Here's how they work:

                </p>

                <ul>

                    <li><strong>Shape:</strong> Browse diamonds by shape, such as Round, Princess, Oval, Emerald, and

                        more.</li>

                    <li><strong>Carat:</strong> Select diamonds based on their size and weight, ranging from subtle to

                        statement-making.</li>

                    <li><strong>Price:</strong> Set your budget to view diamonds within your desired price range.</li>

                    <li><strong>Color:</strong> Filter diamonds from colorless (D) to light yellow (Z) on the GIA

                        grading scale.</li>

                    <li><strong>Clarity:</strong> Pick diamonds with clarity grades from Flawless (FL) to Included (I1,

                        I2), depending on your preferences.</li>

                    <li><strong>Cut:</strong> Choose the cut grade (e.g., Ideal, Excellent, Very Good) to ensure optimal

                        brilliance and sparkle.</li>

                    <li><strong>Lab Certification:</strong> Find diamonds certified by renowned organizations like GIA,

                        IGI, or HRD.</li>

                </ul>

            </div>

            <div class="card">

                <h3>4. Diamond Details</h3>

                <p>Tap on any diamond to view its full specifications, including Shape, Carat, Color, Clarity, Polish,

                    Symmetry, Fluorescence, Lab, and more. You can also view the 360-degree interactive image to explore

                    the diamond from all angles.</p>

            </div>

            <!--<div class="card">-->

            <!--    <h3>5. Diamond Comparison</h3>-->

            <!--    <p>Select multiple diamonds to compare their specifications side-by-side. Save comparisons for future-->

            <!--        reference.</p>-->

            <!--</div>-->

            <!--<div class="card">-->

            <!--    <h3>5. Add to Cart</h3>-->

            <!--    <p>Once you find the perfect diamond, tap the "Add to Cart" button on the product page. Review your-->

            <!--        selections in the "Cart" tab before proceeding to checkout.</p>-->

            <!--</div>-->

            <div class="card">

              <h3>5. Diamond Product Management</h3>

              <p>

                Use the tools below to manage your diamond inventory. You can import/export CSV files, download sample files, or update products using the API.

              </p>

            

              <h4> Download Sample Products</h4>

              <ul>

                <li>Click the <strong>Sample Products</strong> button to download a pre-formatted CSV file.</li>

                <li>This file shows the correct structure and column names required for importing.</li>

              </ul>

            

              <h4> Export Diamond Products</h4>

              <ul>

                <li>Click the <strong>Export Products</strong> button to download all current diamond products in CSV format.</li>

                <li>This is useful for backups or bulk editing in Excel/Google Sheets.</li>

              </ul>

            

              <h4> Import Diamond Products</h4>

              <ul>

                <li>Click <strong>Choose File</strong> to upload a properly formatted CSV file.</li>

                <li>Then click <strong>Import Products</strong> to insert or update products into the database.</li>

                <li>Ensure your CSV follows the correct format (see sample for reference).</li>

              </ul>

            

              <p><strong>️ Note:</strong> The import process checks for duplicates based on stock ID or diamond ID and updates them accordingly.</p>

            </div>

          <div class="card">

          <h3>6. Diamond Product API Integration Guide</h3>

          <p>This section explains how to retrieve diamond product data from the external API using your token.</p>

        

          <h4> API Endpoint</h4>

          <p>

            <code>GET https://braintreeeasysoft.com/braintree_app/api/diamond-products</code>

          </p>

        

          <h4> Required Headers</h4>

          <ul>

            <li><strong>Authorization:</strong> <code>Bearer demoProduct</code></li>

            <li><strong>Accept:</strong> <code>application/json</code></li>

          </ul>

        

          <h4> Sample cURL Request</h4>

          <pre style="background:#f6f8fa;padding:10px;border-radius:6px;overflow-x:auto;">

         curl --location 'https://braintreeeasysoft.com/braintree_app/api/diamond-products' \

            --header 'Authorization: Bearer demoProduct' \

            --header 'Accept: application/json'

          </pre>

        

          <h4> Sample JSON Response</h4>

          <pre style="background:#f6f8fa;padding:10px;border-radius:6px;overflow-x:auto;">

        {

        "success": true,

        "data": [

            {

                "diamond_id": 1,

                "stock_id": "06-282",

                "availability": "1",

                "shape": "Pear",

                "weight": "0.48",

                "color": "D",

                "clarity": "VS2",

                "cut_grade": "VG",

                "grade": "VG",

                "cut": "VG",

                "polish": "VG",

                "symmetry": "VG",

                "fluorescence_int": "None",

                "fluorescence_color": "None",

                "measurements": "7.28 x 4.30 x 2.59",

                "m_length": "7.28",

                "m_width": "4.3",

                "m_depth": "2.59",

                "lab": "IGI",

                "treatment": "None",

                "is_fancy": "0",

                "fancy_color": "",

                "fancy_color_intensity": "",

                "fancy_color_overtone": "",

                "depth": "60.2",

                "table_d": "62",

                "girdle_thin": "",

                "girdle_thick": "",

                "girdle_perct": "0.0",

                "girdle_con": "MEDIUM TO THICK - Faceted",

                "culet_size": "None",

                "culet_con": "",

                "crown_ht": "12.5",

                "crown_angle": "33.1",

                "pavillion_depth": "45.0",

                "pavillion_angle": "41.4",

                "laser_inscription": null,

                "cert_comments": "",

                "country": "United States",

                "state": "",

                "city": "New York",

                "origin": "",

                "keytosymb": "",

                "shade": "",

                "star_len": "",

                "report_dt": "",

                "report_type": "",

                "milky": "",

                "eye_clean": "",

                "gemprint_ID": "",

                "BGM": "None",

                "ratio": "1.69",

                "diamond_type": "",

                "member_comment": "",

                "time_to_location": "",

                "LsMatchedPairSeparable": "",

                "pair_stock": "",

                "allow_raplink_feed": "",

                "parcel_stones": "",

                "center_inclusion": "",

                "black_inclusion": "",

                "lab_location": "",

                "brand": "",

                "Sarine_Name": "",

                "Internal_Clarity_Desc_Code": "",

                "Clarity_Description": "",

                "Modified_Rate": "",

                "wire_discount_price": "",

                "diamond_image": "https://d24ppbhzdyfrur.cloudfront.net/uploads/image_url/s3_image/65986263/still_111123a6-30e2-4624-9af5-b4c6bc075cab.jpg",

                "diamond_image_2": null,

                "diamond_image_3": null,

                "diamond_image_4": null,

                "diamond_image_5": null,

                "diamond_image_6": null,

                "diamond_video": "https://www.labgrownforever.com/videoplayer.php?stoneid=06-282",

                "Video_HTML": "https://www.medialink.email/v1/admin/diamonds/63580372/non_orbit",

                "CertificateLink": "https://www.igi.org/API-IGI/viewpdf-url.php?r=579364161",

                "Rap_Price": "960.0",

                "Memo_Price": "",

                "Memo_Discount_PER": "",

                "Buy_Price": 138,

                "Buy_Price_Discount_PER": "",

                "COD_Buy_Price": "",

                "COD_Buy_Price_Discount_PER": "",

                "price_per_carat": null,

                "Certificate": "579364161",

                "cash_price": 138,

                "report_filename": "",

                "rapnet": "",

                "rapnet_discount": null,

                "featured": null,

                "table_open": null,

                "crown_open": null,

                "girdle_open": null,

                "luster": null,

                "type": null,

                "tinge": null,

                "location_of_black": null,

                "table_inclusion": null,

                "surface_graining": null,

                "internal_graining": null,

                "inclusion_pattern": null,

                "diamond_origin_report": null,

                "short_title": "Pear 0.48ct D VS2",

                "growth_type": null,

                "H&A": null,

                "share_access": null,

                "is_upload": 0,

                "is_update": 0,

                "product_id": null,

                "vendor_id": "18979",

                "vendor_name": "Created Diamonds Inc",

                "feed_type": "API",

                "created_at": "2023-05-17T15:36:13.347000Z",

                "edited_at": "2024-12-19T08:12:29.141Z",

                "description": "<ul><li><strong>SHAPE</strong> Pear</li><li><strong>CARAT</strong> 0.48ct.</li><li><strong>COLOR</strong> D</li><li><strong>CLARITY</strong> VS2</li><li><strong>CUT</strong> VG</li><li><strong>REPORT</strong> IGI</li><li><strong>CERTIFICATE NO</strong> <a target=\"_blank\" href=\"https://www.igi.org/API-IGI/viewpdf-url.php?r=579364161\">579364161</a></li><li><strong>LENGTH</strong> 7.28 mm</li><li><strong>WIDTH</strong> 4.3 mm</li><li><strong>DEPTH</strong> 2.59 mm</li><li><strong>TABLE (%)</strong> 62 %</li><li><strong>DEPTH (%)</strong> 60.2 %</li><li><strong>SYMMETRY</strong> VG</li><li><strong>POLISH</strong> VG</li><li><strong>FLUORESCENCE</strong> None</li><li><strong>MEASUREMENTS</strong> 7.28 x 4.30 x 2.59</li><li><strong>RATIO</strong> 1.69</li></ul>",

                "updated_at": null

            }

        ]

    }

          </pre>

        

          <p>

             This API is used for importing diamond data into your system.<br>

             Make sure to use a valid API token and expect the data inside the <code>data</code> array.

          </p>

        </div>





        </section>



        <section id="customer-support">

            <h2>Customer Support</h2>

            <p>If you need any assistance, feel free to contact our support team:</p>

            <ul>

                <li><strong>Email:</strong> <a href="mailto:praveen@braintreeproducts.com">praveen@braintreeproducts.com</a></li>
                <li><strong>Email:</strong> <a href="mailto:pinky@braintreeproducts.com">pinky@braintreeproducts.com</a></li>

            </ul>

        </section>

    </div>



    <footer>

        <p>&copy; 2025 Diamond App. All Rights Reserved.</p>

    </footer>

</body>



</html><?php /**PATH /home/braintreeeasysof/public_html/braintree_app/resources/views/userguide.blade.php ENDPATH**/ ?>