<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy Policy</title>
    <style>
        /* General Reset */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            color: #333;
            line-height: 1.6;
            padding-bottom: 60px;
        }

        section#privacy-policy {
            background-color: #fff;
            padding: 40px 20px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        h1.main-head {
            text-align: center;
            font-size: 36px;
            margin-bottom: 20px;
            color: #333;
        }

        .intoduction h1 {
            font-size: 30px;
            margin-bottom: 15px;
            color: #333;
        }

        h2 {
            font-size: 28px;
            color: #2c3e50;
            padding-bottom: 10px;
        }

        h3 {
            font-size: 24px;
            margin-top: 30px;
            color: #2c3e50;
        }

        p {
            font-size: 18px;
            line-height: 1.6;
            color: #555;
        }

        ul {
            list-style: none;
            margin-left: 0;
            padding-left: 0;
            margin-top: 10px;
        }

        li {
            font-size: 18px;
            line-height: 1.8;
            margin-bottom: 10px;
            color: #555;
        }

        .privacy-types {
            background-color: #f9f9f9;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 30px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        .privacy-types ul {
            padding-left: 20px;
            margin-top: 10px;
        }

        .privacy-types li {
            margin-left: 10px;
            line-height: 1.8;
        }

        .privacy-types b {
            color: #2980b9;
        }

        footer {
            background-color: #333;
            color: white;
            text-align: center;
            padding: 20px;
            margin-top: 40px;
        }

        footer p {
            font-size: 16px;
        }

        @media (max-width: 768px) {
            h1.main-head {
                font-size: 28px;
            }

            .container {
                padding: 0 10px;
            }

            h2,
            h3 {
                font-size: 24px;
            }

            p {
                font-size: 16px;
            }
        }
    </style>
</head>

<body>

    <section id="privacy-policy">
        <div class="container">
            <h1 class="main-head">Privacy Policy</h1>

            <div class="privacy-types">
                <h2>1. Introduction</h2>
                <p>Welcome to Braintree Products. We respect your privacy and are committed to protecting your personal information. This Privacy Policy explains how we collect, use, and disclose your information.</p>
            </div>

            <div class="privacy-types">
                <h2>2. Information We Collect</h2>
                <p>We may collect personal information such as your name, email address, payment details, and any other information you provide to us directly. Additionally, we may collect non-personal information such as browsing data and IP addresses.</p>
            </div>

            <div class="privacy-types">
                <h2>3. How We Use Your Information</h2>
                <p>Your information is used to provide and improve our services, process transactions, and communicate with you. We may also use it for marketing purposes with your consent.</p>
            </div>

            <div class="privacy-types">
                <h2>4. How We Share Your Information</h2>
                <p>We do not sell your personal information. We may share your information with third-party service providers to facilitate our services, comply with legal obligations, or protect our rights.</p>
            </div>

            <div class="privacy-types">
                <h2>5. Your Rights</h2>
                <p>You have the right to access, update, or delete your personal information. You can also opt-out of marketing communications at any time.</p>
            </div>

            <div class="privacy-types">
                <h2>6. Security</h2>
                <p>We implement appropriate security measures to protect your information from unauthorized access, alteration, or disclosure.</p>
            </div>

            <div class="privacy-types">
                <h2>7. Changes to This Policy</h2>
                <p>We may update this Privacy Policy from time to time. We will notify you of any significant changes.</p>
            </div>

            <div class="privacy-types">
                <h2>8. Contact Us</h2>
                <p>If you have any questions about this Privacy Policy, please contact us at:</p>
                <p><strong>Email:</strong> <a href="mailto:praveen@braintreeproducts.com">praveen@braintreeproducts.com</a></p>
            </div>
        </div>
    </section>
</body>

</html>