<?php

namespace App\Imports;

use App\Models\DiamondProduct;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class DiamondProductImport implements ToModel, WithHeadingRow
{
    protected $userId;

    // Constructor to accept user_id
    public function __construct($userId)
    {
        $this->userId = $userId;
    }

public function model(array $row)
{
    return DiamondProduct::updateOrCreate(
        // Search criteria: Match based on 'user_id' and 'stock_id'
        [
            'user_id' => $this->userId,
            'stock_id' => $row['stock_id'] ?? null,  // Use null coalescing operator for shorter code
        ],
        // Attributes to update or create
        [
            'availability' => $row['availability'] ?? null,
            'shape' => $row['shape'] ?? null,
            'weight' => $row['weight'] ?? null,
            'color' => $row['color'] ?? null,
            'clarity' => $row['clarity'] ?? null,
            'cut_grade' => $row['cut_grade'] ?? null,
            'grade' => $row['grade'] ?? null,
            'cut' => $row['cut'] ?? null,
            'polish' => $row['polish'] ?? null,
            'symmetry' => $row['symmetry'] ?? null,
            'fluorescence_int' => $row['fluorescence_int'] ?? null,
            'fluorescence_color' => $row['fluorescence_color'] ?? null,
            'measurements' => $row['measurements'] ?? null,
            'm_length' => $row['m_length'] ?? null,
            'm_width' => $row['m_width'] ?? null,
            'm_depth' => $row['m_depth'] ?? null,
            'lab' => $row['lab'] ?? null,
            'treatment' => $row['treatment'] ?? null,
            'is_fancy' => $row['is_fancy'] ?? null,
            'fancy_color' => $row['fancy_color'] ?? null,
            'fancy_color_intensity' => $row['fancy_color_intensity'] ?? null,
            'fancy_color_overtone' => $row['fancy_color_overtone'] ?? null,
            'depth' => $row['depth'] ?? null,
            'table_d' => $row['table_d'] ?? null,
            'girdle_thin' => $row['girdle_thin'] ?? null,
            'girdle_thick' => $row['girdle_thick'] ?? null,
            'girdle_perct' => $row['girdle_perct'] ?? null,
            'girdle_con' => $row['girdle_con'] ?? null,
            'culet_size' => $row['culet_size'] ?? null,
            'culet_con' => $row['culet_con'] ?? null,
            'crown_ht' => $row['crown_ht'] ?? null,
            'crown_angle' => $row['crown_angle'] ?? null,
            'pavillion_depth' => $row['pavillion_depth'] ?? null,
            'pavillion_angle' => $row['pavillion_angle'] ?? null,
            'laser_inscription' => $row['laser_inscription'] ?? null,
            'cert_comments' => $row['cert_comments'] ?? null,
            'country' => $row['country'] ?? null,
            'state' => $row['state'] ?? null,
            'city' => $row['city'] ?? null,
            'origin' => $row['origin'] ?? null,
            'keytosymb' => $row['keytosymb'] ?? null,
            'shade' => $row['shade'] ?? null,
            'star_len' => $row['star_len'] ?? null,
            'report_dt' => $row['report_dt'] ?? null,
            'report_type' => $row['report_type'] ?? null,
            'milky' => $row['milky'] ?? null,
            'eye_clean' => $row['eye_clean'] ?? null,
            'gemprint_ID' => $row['gemprint_ID'] ?? null,
            'BGM' => $row['BGM'] ?? null,
            'ratio' => $row['ratio'] ?? null,
            'diamond_type' => $row['diamond_type'] ?? null,
            'member_comment' => $row['member_comment'] ?? null,
            'time_to_location' => $row['time_to_location'] ?? null,
            'LsMatchedPairSeparable' => $row['LsMatchedPairSeparable'] ?? null,
            'pair_stock' => $row['pair_stock'] ?? null,
            'allow_raplink_feed' => $row['allow_raplink_feed'] ?? null,
            'parcel_stones' => $row['parcel_stones'] ?? null,
            'center_inclusion' => $row['center_inclusion'] ?? null,
            'black_inclusion' => $row['black_inclusion'] ?? null,
            'lab_location' => $row['lab_location'] ?? null,
            'brand' => $row['brand'] ?? null,
            'Sarine_Name' => $row['Sarine_Name'] ?? null,
            'Internal_Clarity_Desc_Code' => $row['Internal_Clarity_Desc_Code'] ?? null,
            'Clarity_Description' => $row['Clarity_Description'] ?? null,
            'Modified_Rate' => $row['Modified_Rate'] ?? null,
            'wire_discount_price' => $row['wire_discount_price'] ?? null,
            'diamond_image' => $row['diamond_image'] ?? null,
            'diamond_image_2' => $row['diamond_image_2'] ?? null,
            'diamond_image_3' => $row['diamond_image_3'] ?? null,
            'diamond_image_4' => $row['diamond_image_4'] ?? null,
            'diamond_image_5' => $row['diamond_image_5'] ?? null,
            'diamond_image_6' => $row['diamond_image_6'] ?? null,
            'diamond_video' => $row['diamond_video'] ?? null,
            'Video_HTML' => $row['Video_HTML'] ?? null,
            'CertificateLink' => $row['CertificateLink'] ?? null,
            'Rap_Price' => $row['Rap_Price'] ?? null,
            'Memo_Price' => $row['Memo_Price'] ?? null,
            'Memo_Discount_PER' => $row['Memo_Discount_PER'] ?? null,
            'Buy_Price' => $row['Buy_Price'] ?? null,
            'Buy_Price_Discount_PER' => $row['Buy_Price_Discount_PER'] ?? null,
            'COD_Buy_Price' => $row['COD_Buy_Price'] ?? null,
            'COD_Buy_Price_Discount_PER' => $row['COD_Buy_Price_Discount_PER'] ?? null,
            'price_per_carat' => $row['price_per_carat'] ?? null,
            'Certificate' => $row['certificate'] ?? null,
            'cash_price' => $row['cash_price'] ?? null,
            'report_filename' => $row['report_filename'] ?? null,
            'rapnet' => $row['rapnet'] ?? null,
            'rapnet_discount' => $row['rapnet_discount'] ?? null,
            'featured' => $row['featured'] ?? null,
            'table_open' => $row['table_open'] ?? null,
            'crown_open' => $row['crown_open'] ?? null,
            'girdle_open' => $row['girdle_open'] ?? null,
            'luster' => $row['luster'] ?? null,
            'type' => $row['type'] ?? null,
            'tinge' => $row['tinge'] ?? null,
            'location_of_black' => $row['location_of_black'] ?? null,
            'table_inclusion' => $row['table_inclusion'] ?? null,
            'surface_graining' => $row['surface_graining'] ?? null,
            'internal_graining' => $row['internal_graining'] ?? null,
            'inclusion_pattern' => $row['inclusion_pattern'] ?? null,
            'diamond_origin_report' => $row['diamond_origin_report'] ?? null,
            'short_title' => $row['short_title'] ?? null,
            'growth_type' => $row['growth_type'] ?? null,
            'H&A' => $row['H&A'] ?? null,
            'share_access' => $row['share_access'] ?? null,
            'is_upload' => $row['is_upload'] ?? 0,  // Default to 0 if not set
            'is_update' => $row['is_update'] ?? 0,  // Default to 0 if not set
            'product_id' => $row['product_id'] ?? null,
            'vendor_id' => $row['vendor_id'] ?? null,
            'vendor_name' => $row['vendor_name'] ?? null,
            'feed_type' => $row['feed_type'] ?? null,
        ]
    );
}


}
