<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SetShopifyHeaders
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        // Ensure the 'host' parameter is in the request
        if (!$request->has('host')) {
            $shop = $request->get('shop');

            if ($shop) {
                // Base64 encode the host part
                $encodedHost = base64_encode("admin.shopify.com/store/{$shop}");

                // Redirect and append the 'host' parameter to the query string
                return redirect()->to($request->fullUrlWithQuery(['host' => $encodedHost]));
            }
        }

        // Proceed to the next middleware if the 'host' is already present
        return $next($request);
    }
}
