<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Pagination\Paginator;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;
use Illuminate\Support\Facades\Auth;
use Tymon\JWTAuth\Facades\JWTAuth;


use App\Models\User;
use Illuminate\Support\Facades\View;
use App\Models\Diamond;


class DiamondController extends Controller
{
    
    public function index(Request $request)
    {
      echo "Welcome to my app.";
    }
    
    public function load_more_data(Request $request){
     
      $stock_id = $request->stock_id; 
      $store_name = $request->store_name;
      $page_name = $request->page_name;
      $shop = $request->shop;
       /*************************** */ 
       if ($shop) {
        $user = User::where('name', $shop)->first();
        
        
  
                         
        // Fetch Shop Info
        $shopInfoResponse = $user->api()->rest('GET', '/admin/api/2024-01/shop.json');
        $shopInfo = $shopInfoResponse['body']['shop'] ?? null;

        // Fetch Themes
        $themesResponse = $user->api()->rest('GET', '/admin/api/2024-01/themes.json');
        $themes = $themesResponse['body']['themes'] ?? null;

        // Get Current Theme
        $currentTheme = collect($themes)->firstWhere('role', 'main'); 
        if (!$shopInfo || !$currentTheme) {
            return response()->json([
                'error' => 'Failed to fetch shop info or themes.',
            ]);
        }

        $storeName = explode('.', $shopInfo['myshopify_domain'])[0]; 
        $themeId = $currentTheme['id'];

        // Fetch settings_data.json
        $settingsResponse = $user->api()->rest('GET', "/admin/api/2024-01/themes/{$themeId}/assets.json", [
            'asset[key]' => 'config/settings_data.json',
        ]);
    //dd($settingsResponse);
        $blocks = [];
        if ($settingsResponse['status'] === 200) {
            $settingsData = json_decode($settingsResponse['body']['asset']['value'] ?? '{}', true);
            if (isset($settingsData['current']['blocks'])) {
              foreach ($settingsData['current']['blocks'] as $blockId => $block) {
                  if (isset($block['type']) && str_contains($block['type'], 'shopify://apps/braintree-products-app/blocks/app_embed')) {
                        $status_pr =$block['disabled'] ;
                      
                    }
                }
            }
        }

    }
      /*************************** */ 
          $page=$request->page ?? 1;
          $per_page=$request->per_page ?? 50;

          $is_fancy=$request->is_fancy ?? 0;
          
      
          $where = "cash_price >= 35 AND is_fancy = '$is_fancy' ";


          // $stock = $request->stock;       
          // if(!empty($stock)) {                   
          //   $replacedStr = str_replace("," , "','", $stock);    
          //   $where .= " AND stock_id IN ('$replacedStr') OR  `Certificate` IN ('$replacedStr')"; 
          //   // $where .= " AND stock_id IN ('$replacedStr') OR  `Certificate` Like '%$replacedStr%'"; 
          // } 

          $stock = $request->stock;
          if (!empty($stock)) {
              // Replace commas with the pattern delimiter for SQL LIKE ('%' in this case)
              $replacedStr = str_replace(",", "%' OR `Certificate` LIKE '%", $stock);
              
              // Construct the WHERE clause to match patterns using LIKE
              $where .= " AND (stock_id LIKE '%$replacedStr%' OR `Certificate` LIKE '%$replacedStr%')";
          }

      
          $shape = $request->checkbox;
          // print_ex($shape);
          if (!empty($shape)) {
            $replacedStr = implode("','",$shape);             
            $where .= " AND shape IN ('$replacedStr')";      
          }

          $color = $request->color;                   
          if($is_fancy == '0'){
            if(!empty($color))
            {
                $color_array=array("D", "E", "F", "G", "H");
                $color_array=$this->find_range($color,$color_array);
                $q2=implode("','",$color_array);
                $where .= " AND color IN ('".$q2."')";           
            }
          }else{
            if(!empty($color))
            {
              $replacedStr = implode("','",$color);             
              $where .= " AND color IN ('$replacedStr')";
            }   
          }
          
          $checkboxcut = $request->cut;                
          if(!empty($checkboxcut))
          {         
              $array_va=array("EX", "VG", "G", "FR");
              $checkboxcut=$this->find_range($checkboxcut,$array_va);
              // if(in_array('Round',  $shape))
              // {
                $qcut = implode("','", $checkboxcut);
                $where .= " AND cut IN ('".$qcut."')";
              // }                  
          } 
          
          $checkboxClarity = $request->clarity;
          if(!empty($checkboxClarity))
          {        
            // $clarity_va=array("FL","IF","VVS1","VVS2","VS1","VS2","SI1","SI2","SI3","I1","I2","I3");
            $clarity_va=array("FL","IF","VVS1","VVS2","VS1","VS2","SI1","SI2","SI3","I1","I2","I3");
            $checkboxClarity=$this->find_range($checkboxClarity,$clarity_va);
            $qClarity = implode("','", $checkboxClarity);
            $where .= " AND clarity IN ('".$qClarity."')";
          }  


          $price_from = $request->price_from;
          $price_to = $request->price_to;

          if (trim($price_from) != '' && trim($price_to)) {      
            $price_to = ($price_to=='0') ? '10000000' : $price_to;
            $where .= " AND cash_price BETWEEN ($price_from) AND ($price_to)";
          }


          $carat_from = $request->carat_from;
          $carat_to = $request->carat_to;
          if (trim($carat_from) != '' && trim($carat_to)) {      
            $carat_to = ($carat_to=='0') ? '200' : $carat_to;
            $where .= " AND weight BETWEEN ($carat_from) AND ($carat_to)";
          }

          $lab = $request->lab;
          // print_ex($shape);
          if (!empty($lab)) {
            $replacedStr = implode("','",$lab);             
            $where .= " AND lab IN ('$replacedStr')";      
          }
          
        //   $where .= " AND lab NOT LIKE '%MATCHING PAIR%'";


          $per_pages = $request->per_pages ?? 50;
          $limit = ($per_pages != '') ? $per_pages : $per_page ;
          $offset = ($page - 1) * $limit;
         
          $orders = "ORDER BY cash_price ASC";
          
                                 
      if (!empty($user)) {
            $userId = $user['id'];  
            $where .= "AND user_id =".$userId;
        }
        
        
         // $query = "select * from tbl_diamond where " .$where." $orders limit $offset,$limit"; 
       // Check if 'user_id' is part of the where clause
$whereForTblDiamond = $where;
if (strpos($where, 'user_id') !== false) {
    // Remove 'user_id' condition from where clause
    $whereForTblDiamond = preg_replace('/\s*AND\s*user_id\s*=\s*\d+/i', '', $where);
}

// First try querying the 'diamonds' table
$query = "SELECT * FROM diamonds WHERE " . $where . " $orders LIMIT $offset, $limit";
$records = DB::select($query);

// // If no records are found, switch to the 'tbl_diamond' table without the user_id
// if (empty($records)) {
//     $query = "SELECT * FROM tbl_diamond WHERE " . $whereForTblDiamond . " $orders LIMIT $offset, $limit";
//     $records = DB::select($query);
// }

// Query to get the record count using the 'diamonds' table
$query1 = "SELECT COUNT(diamond_id) AS diamond_count FROM diamonds WHERE " . $where;
$records_count = DB::select($query1);

// // If record count is empty or zero, switch to 'tbl_diamond' and exclude the user_id condition
// if (empty($records_count) || $records_count[0]->diamond_count == 0) {
//     $query1 = "SELECT COUNT(diamond_id) AS diamond_count FROM tbl_diamond WHERE " . $whereForTblDiamond;
//     $records_count = DB::select($query1);
// }

          $data['records_count'] =$records_count['0']->diamond_count;
         
            $total_records = $records_count[0]->diamond_count;
            
            // Generate pagination links
            $pagination = $this->generate_pagination($page, $total_records, $limit);

          $response_data = [
            'product_id' => $product_id ?? '',
            'variants_id' => $variants_id ?? '',
            'records' => $records,
            'page_link' => $pagination ?? '',
            'total_records' => $data['records_count'],
            'query' => $query,
            'theme_json' => $theme_json ?? '',
            'isLogin' => 1,
            'page_name' => $page_name,
            'massage_pr'=> $status_pr,
             'userId' => $user['id']
        ];
    
        return response()->json($response_data)
                         ->header('Access-Control-Allow-Origin', '*')
                         ->header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS')
                         ->header('Access-Control-Allow-Headers', 'Content-Type, Authorization');
      
       
    }
    
    public function generate_pagination($current_page, $total_records, $per_page)
    {
        $total_pages = ceil($total_records / $per_page); // Calculate total pages
    
        $pagination = '';
    
        // Previous Button
        if ($current_page > 1) {
            $pagination .= '<a href="javascript:void(0);" onclick="loadMoreData(\'https://braintreeeasysoft.com/braintree_app/load-more-diamond?page='.($current_page - 1).'\')" class="pagination-btn">Previous</a>';
        }
    
        // Page Numbers
        $page_range = 2; // Display 2 pages before and after the current page
        $start_page = max(1, $current_page - $page_range);
        $end_page = min($total_pages, $current_page + $page_range);
    
        // Add first page and "..." if there's a gap
        if ($start_page > 1) {
            $pagination .= '<a href="javascript:void(0);" onclick="loadMoreData(\'https://braintreeeasysoft.com/braintree_app/load-more-diamond?page=1\')" class="pagination-btn">1</a>';
            if ($start_page > 2) {
                $pagination .= '<span class="pagination-dots">...</span>';
            }
        }
    
        // Loop through the page numbers
        for ($i = $start_page; $i <= $end_page; $i++) {
            if ($i == $current_page) {
                $pagination .= '<a href="javascript:void(0);" class="pagination-btn active">' . $i . '</a>';
            } else {
                $pagination .= '<a href="javascript:void(0);" onclick="loadMoreData(\'https://braintreeeasysoft.com/braintree_app/load-more-diamond?page='.$i.'\')" class="pagination-btn">' . $i . '</a>';
            }
        }
    
        // Add last page and "..." if there's a gap
        if ($end_page < $total_pages) {
            if ($end_page < $total_pages - 1) {
                $pagination .= '<span class="pagination-dots">...</span>';
            }
            $pagination .= '<a href="javascript:void(0);" onclick="loadMoreData(\'https://braintreeeasysoft.com/braintree_app/load-more-diamond?page='.$total_pages.'\')" class="pagination-btn">'.$total_pages.'</a>';
        }
    
        // Next Button
        if ($current_page < $total_pages) {
            $pagination .= '<a href="javascript:void(0);" onclick="loadMoreData(\'https://braintreeeasysoft.com/braintree_app/load-more-diamond?page='.($current_page + 1).'\')" class="pagination-btn">Next</a>';
        }
    
        return $pagination;
    }
    

    public function diamond_details(Request $request){
     
      $stock_id = $request->stock_id;
      $vendor_id = $request->vendor_id;

      $diamond_query = "select * from tbl_diamond where stock_id = '$stock_id' limit 1";
      $diamond_record = DB::select($diamond_query);
      $response_data = [
        'records'=>$diamond_record,
        // 'page_name' => $page_name
      ];
      
      return response()->json($response_data)
                         ->header('Access-Control-Allow-Origin', '*')
                         ->header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS')
                         ->header('Access-Control-Allow-Headers', 'Content-Type, Authorization');
    }

    public function add_to_cart(Request $request){
     
      $stock_id = $request->stock_id;
      $vendor_id = $request->vendor_id;
      $shop_name = $request->shop_name;

      $user_query = "select * from users where name = '$shop_name' limit 1";
      $user_record = DB::select($user_query);
      $user_id = $user_record[0]->id;


      $cart_query = "select * from tbl_cart where stock_id = '$stock_id' and vendor_id = '$vendor_id' and user_id = '$user_id'  limit 1";
      $cart_record = DB::select($cart_query);

      $diamond_query = "select * from tbl_diamond where stock_id = '$stock_id' and vendor_id = '$vendor_id'  limit 1";
      $record = DB::select($diamond_query);
    

      if(empty($cart_record)){
        if(!empty($record)){
          foreach($record as $row) {
            if(!empty($row->diamond_image)){
              $diamond_img = $row->diamond_image;
              $alt = $row->shape;
            }else{
              $diamond_img = asset('assets/no_image.jpg');
              $alt = "No image";	
            }

            $vendor = $row->vendor_name." ".$row->vendor_id;
            // $row->Buy_Price = $row->Buy_Price * 1.50;
            $row->Buy_Price = $row->Buy_Price;

            $variants = [
              'sku' => $row->stock_id,
              // 'barcode' => $row->barcode,
              'price' => $row->Buy_Price,
              // 'compare_at_price' => $row->Buy_Price,
              'cost' =>$row->Buy_Price,                    
              'inventory_quantity' => 1,
              // 'grams' => $row->grams,
              'taxable' => true,
              'requires_shipping' => true,
              'fulfillment_service' => 'manual',
              'inventory_policy' => 'deny',
              'inventory_management' => 'shopify'
            ];
      
          
            $row->title = $row->weight . " Carat " . $row->shape ." ". $row->color ." ". $row->clarity . " Lab Diamond ";
            // $row->title = "Demo Lab Diamond";

            $is_fancy = ($row->is_fancy == 1) ? 'fancy' : 'not_fancy';
            $dataSend = [
              'product' => [
                'title' => $row->title,
                'body_html' => $row->description,
                'product_type' => 'lab_grown_diamonds',
                'handle' => $row->stock_id,
                'status' => 'active',
                'vendor' => $vendor,
                'published_scope' => 'pos',
                'tags' => $is_fancy,
                'variants' => [
                  $variants
                ],
                'images' => [
                  [
                    "position"=> 1,
                    "alt"=> $alt,
                    "src"=> $diamond_img 
                  ]
                ],
                'metafields' => [
                      [
                        'namespace' => "Diamond",
                        'key' => "stock_id",
                        'value' => $row->stock_id,
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "title",
                        'value' => $row->title,
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "availability",
                        'value' => !empty($row->availability) ? $row->availability : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "shape",
                        'value' => !empty($row->shape) ? $row->shape : 'Other',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "weight",
                        'value' => (!empty($row->weight)) ? $row->weight : "None",
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "color",
                        'value' => !empty($row->color) ? $row->color : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "clarity",
                        'value' => !empty($row->clarity) ? $row->clarity : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "cut",
                        'value' => !empty($row->cut) ? $row->cut : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "polish",
                        'value' => !empty($row->polish) ? $row->polish : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "symmetry",
                        'value' => !empty($row->symmetry) ? $row->symmetry : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "fluor",
                        'value' => !empty($row->fluorescence_int) ? $row->fluorescence_int : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "Fluorescence_Color",
                        'value' => !empty($row->fluorescence_color) ? $row->fluorescence_color : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "measurements",
                        'value' => !empty($row->measurements) ? $row->measurements : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "lab",
                        'value' => !empty($row->lab) ? $row->lab : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "depth",
                        'value' => !empty($row->depth) ? $row->depth : "None",
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "table_d",
                        'value' => !empty($row->table_d) ? $row->table_d : "None",
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "culet_size",
                        'value' => (!empty($row->culet_size)) ? $row->culet_size : "None",
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "crown_angle",
                        'value' => (!empty($row->crown_angle)) ? $row->crown_angle : "None",
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "crown_ht",
                        'value' => (!empty($row->crown_ht)) ? $row->crown_ht : "None",
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "pavillion_angle",
                        'value' => (!empty($row->pavillion_angle)) ? $row->pavillion_angle : "None",
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "pavillion_depth",
                        'value' => (!empty($row->pavillion_depth)) ? $row->pavillion_depth : "None",
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "star_len",
                        'value' => (!empty($row->star_len)) ? $row->star_len : "None",
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "Member_Comments",
                        'value' => (!empty($row->member_comment)) ? $row->member_comment : 'None',
                        'type' => "multi_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "country",
                        'value' => (!empty($row->country)) ? $row->country : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "state",
                        'value' => (!empty($row->state)) ? $row->state : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "city",
                        'value' => (!empty($row->city)) ? $row->city : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "price",
                        'value' => (!empty($row->Buy_Price)) ? $row->Buy_Price : "None",
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "ratio",
                        'value' => (!empty($row->ratio)) ? $row->ratio : "None",
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "ImageLink",
                        'value' => (!empty($row->diamond_image)) ? $row->diamond_image : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "VideoLink",
                        'value' => (!empty($row->diamond_video)) ? $row->diamond_video : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "Video_HTML",
                        'value' => (!empty($row->Video_HTML)) ? $row->Video_HTML : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "CertificateLink",
                        'value' => (!empty($row->CertificateLink)) ? $row->CertificateLink : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "Rap_Price",
                        'value' => (!empty($row->rapnet)) ? $row->rapnet : "None",
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "growth_type",
                        'value' => (!empty($row->growth_type)) ? $row->growth_type : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "short_title",
                        'value' => (!empty($row->short_title)) ? $row->short_title : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "is_fancy",
                        'value' => (!empty($row->is_fancy)) ? $row->is_fancy : 1,
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "vendor_name",
                        'value' => (!empty($row->vendor_name)) ? $row->vendor_name : 'None',
                        'type' => "single_line_text_field",
                      ],
                      [
                        'namespace' => "Diamond",
                        'key' => "vendor_id",
                        'value' => (!empty($row->vendor_id)) ? $row->vendor_id : "None",
                        'type' => "single_line_text_field",
                      ]

                ],
              ]

            ];
          }

          $newRecord = $this->createDiamonds(json_encode($dataSend),$shop_name);
        
          if(empty($newRecord)){
                  $response_data = [
                    'message'=>$newRecord ?? ''
                  ];
                  
                  return response()->json($response_data)
                                    ->header('Access-Control-Allow-Origin', '*')
                                    ->header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS')
                                    ->header('Access-Control-Allow-Headers', 'Content-Type, Authorization');
          }else{

            // $user_id = 6;
            $product_id = $newRecord->product->id;
            $variant_id = $newRecord->product->variants[0]->id;
            $quantity = 1;
            $price = $row->Buy_Price;
            // $vendor_id= $vendor;
            $shopify_response = json_encode($newRecord);
            $shopify_upload = 1;
            $shopify_update = 0;
            $shopify_delete = 0;
            $created_at = date('Y-m-d H:i:s');
            $updated_at = date('Y-m-d H:i:s');
            try {
              DB::insert("
                  INSERT INTO tbl_cart (
                      user_id,
                      stock_id,
                      product_id,
                      variant_id,
                      quantity,
                      price,
                      vendor_id,
                      shopify_response,
                      shopify_upload,
                      shopify_update,
                      shopify_delete,
                      created_at,
                      updated_at
                  ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)",
                  [$user_id, $stock_id, $product_id, $variant_id, $quantity, $price, $vendor_id, $shopify_response, $shopify_upload, $shopify_update, $shopify_delete, $created_at, $updated_at]
              );

              $cart_querys = "select * from tbl_cart where stock_id = '$stock_id' and vendor_id = '$vendor_id' and user_id = '$user_id' limit 1";
              $cart_records = DB::select($cart_querys);

              $response_data = [
                'records'=>$cart_records ?? '',
                'message'=>'Product upload successfully',
                'status'=>'true'
              ];
              
              return response()->json($response_data)
                                ->header('Access-Control-Allow-Origin', '*')
                                ->header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS')
                                ->header('Access-Control-Allow-Headers', 'Content-Type, Authorization');

              
            } catch (QueryException $e) { 
              $response_data = [
                'records'=>$record ?? [],
                'message'=>$e->getMessage() ?? '',
                'status'=>'false'
              ];
              
              return response()->json($response_data)
                                ->header('Access-Control-Allow-Origin', '*')
                                ->header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS')
                                ->header('Access-Control-Allow-Headers', 'Content-Type, Authorization');
                // echo "Error inserting data: " . $e->getMessage();
            }
          }
        }
      }else{

        $cart_querys = "select * from tbl_cart where stock_id = '$stock_id' and vendor_id = '$vendor_id' and user_id = '$user_id'  limit 1";
        $cart_records = DB::select($cart_querys);

        $updated_date = date('Y-m-d', strtotime($cart_records[0]->updated_at));
        $current_date = date('Y-m-d');
            
            $response_data = [
              'records'=>$cart_records ?? [],
              'message'=>'successfully',
              'status'=>'true'
            ];

            return response()->json($response_data)
              ->header('Access-Control-Allow-Origin', '*')
              ->header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS')
              ->header('Access-Control-Allow-Headers', 'Content-Type, Authorization');
      }

    }

    function createDiamonds($jsonBody,$shop_name)
    {
        
        if(empty($jsonBody)) {
          return [];
        }

        $user_query = "select * from users where name = '$shop_name' limit 1";
        $user_record = DB::select($user_query);
        $accessToken = $user_record[0]->password;
      
        $shop_url = 'https://'.$shop_name.'/admin/api/2024-10/products.json'; // Replace with your Shopify store URL
        // $accessToken = 'shpua_57650f9b1ef0c76905a467588b5e6e74'; 

        $client = new Client([
            'base_uri' => $shop_url,
        ]);

        $headers = [
            'Content-Type' => 'application/json',
            'X-Shopify-Access-Token' => $accessToken,
        ];

        try {
            $response = $client->request('POST', 'https://'.$shop_name.'/admin/api/2024-07/products.json', [
                'headers' => $headers,
                'body' => $jsonBody,
            ]);

            $body = $response->getBody();
            $parsedBody = json_decode($body);
            // print_r($parsedBody);
            return $parsedBody;

            // return response()->json($parsedBody); // Return JSON response from Shopify
        } catch (\Exception $e) {
            return [];
            // return response()->json(['error' => $e->getMessage()], 500); // Handle any errors
        }
    }

    private function updateDiamonds($jsonBody, $productId,$shop_name) {
      if (empty($jsonBody) || empty($productId)) {
        return [];
      }
      $user_query = "select * from users where name = '$shop_name' limit 1";
      $user_record = DB::select($user_query);
      $accessToken = $user_record[0]->password;
    
      $shop_url = 'https://'.$shop_name.'/admin/api/2024-10/products.json';
      // $accessToken = 'shpua_57650f9b1ef0c76905a467588b5e6e74'; 

      $client = new Client([
        'base_uri' => $shop_url
      ]);
    
      $headers = [
        'Content-Type' => 'application/json',
        'X-Shopify-Access-Token' => $accessToken
      ];
    
      $endpoint = "products/{$productId}.json";
      $maxRetries = 5;
      $retryDelay = 1; // Start with 1 second
    
      for ($attempt = 0; $attempt < $maxRetries; $attempt++) {
        try {
          $response = $client->request('PUT', $endpoint, [
            "headers" => $headers,
            "body" => $jsonBody
          ]);
    
          if ($response->getStatusCode() < 300) {
            $body = $response->getBody();
            return json_decode($body);
          } else {
            throw new \Exception('Non-successful response');
          }
        } catch (\GuzzleHttp\Exception\ClientException $e) {
          if ($e->getCode() == 429 && $attempt < $maxRetries - 1) {
            sleep($retryDelay);
            $retryDelay *= 2; // Exponential backoff
          } else {
            error_log('API request failed: ' . $e->getMessage());
            return [];
          }
        }
      }
    
      return [];
    }

    private function updateMetafield($jsonBody, $product_id, $shop_name) {
      if (empty($jsonBody)) {
          return ['status' => 'error', 'message' => 'Empty input data'];
      }
      $user_query = "select * from users where name = '$shop_name' limit 1";
      $user_record = DB::select($user_query);
      $accessToken = $user_record[0]->password;
  
      $shopUrl = 'https://' . $shop_name;
      // $accessToken = 'shpua_57650f9b1ef0c76905a467588b5e6e74'; // Replace with your access token
      $metafieldsUrl = "$shopUrl/admin/api/2024-10/products/$product_id/metafields.json";
      $client = new \GuzzleHttp\Client();
  
      // Fetch existing metafields
      try {
          $response = $client->request('GET', $metafieldsUrl, [
              'headers' => [
                  'X-Shopify-Access-Token' => $accessToken,
                  'Content-Type' => 'application/json',
              ]
          ]);
          
          $product_metafields = json_decode($response->getBody()->getContents(), true);
          if (!isset($product_metafields['metafields'])) {
              throw new Exception('Failed to retrieve metafields');
          }
  
      } catch (Exception $e) {
          error_log('Exception fetching metafields: ' . $e->getMessage());
          return ['status' => 'error', 'message' => $e->getMessage()];
      }
  
      // New metafield entries
      $metafields = [
          [
              'namespace' => 'Diamond',
              'key' => 'stock_id',
              'value' => $jsonBody->stock_id,
              'type' => 'single_line_text_field',
          ],
          [
              'namespace' => 'Diamond',
              'key' => 'title',
              'value' => $jsonBody->title,
              'type' => 'single_line_text_field',
          ],
          [
            'namespace' => 'Diamond',
            'key' => 'short_title',
            'value' => !empty($jsonBody->short_title) ? $jsonBody->short_title : 'Default Title',
            'type' => 'single_line_text_field',
          ],
          [
              'namespace' => 'Diamond',
              'key' => 'availability',
              'value' => !empty($jsonBody->availability) ? $jsonBody->availability : 'None',
              'type' => 'single_line_text_field',
          ],
          [
              'namespace' => 'Diamond',
              'key' => 'shape',
              'value' => !empty($jsonBody->shape) ? $jsonBody->shape : 'Other',
              'type' => 'single_line_text_field',
          ],
          [
              'namespace' => 'Diamond',
              'key' => 'weight',
              'value' => $jsonBody->weight,
              'type' => 'single_line_text_field',
          ],
          [
              'namespace' => 'Diamond',
              'key' => 'color',
              'value' => !empty($jsonBody->color) ? $jsonBody->color : 'None',
              'type' => 'single_line_text_field',
          ],
          [
              'namespace' => 'Diamond',
              'key' => 'clarity',
              'value' => !empty($jsonBody->clarity) ? $jsonBody->clarity : 'None',
              'type' => 'single_line_text_field',
          ],
          [
              'namespace' => 'Diamond',
              'key' => 'cut',
              'value' => !empty($jsonBody->cut) ? $jsonBody->cut : 'None',
              'type' => 'single_line_text_field',
          ],
          [
              'namespace' => 'Diamond',
              'key' => 'polish',
              'value' => !empty($jsonBody->polish) ? $jsonBody->polish : 'None',
              'type' => 'single_line_text_field',
          ],
          [
              'namespace' => 'Diamond',
              'key' => 'symmetry',
              'value' => !empty($jsonBody->symmetry) ? $jsonBody->symmetry : 'None',
              'type' => 'single_line_text_field',
          ],
          [
              'namespace' => 'Diamond',
              'key' => 'fluor',
              'value' => !empty($jsonBody->fluorescence_int) ? $jsonBody->fluorescence_int : 'None',
              'type' => 'single_line_text_field',
          ],
          [
              'namespace' => 'Diamond',
              'key' => 'Fluorescence_Color',
              'value' => !empty($jsonBody->fluorescence_color) ? $jsonBody->fluorescence_color : 'None',
              'type' => 'single_line_text_field',
          ],
          [
            'namespace' => 'Diamond',
            'key' => 'VideoLink',
            'value' => !empty($jsonBody->diamond_video) ? $jsonBody->diamond_video : 'None',
            'type' => 'single_line_text_field',
          ],
          // Add more fields as necessary
      ];
  
      foreach ($metafields as $metafield) {
          $meta_id = null;
  
          // Check if the metafield already exists
          foreach ($product_metafields['metafields'] as $existingMetafield) {
              if ($existingMetafield['key'] === $metafield['key'] && $existingMetafield['namespace'] === 'Diamond') {
                  $meta_id = $existingMetafield['id'];
                  break;
              }
          }
  
          // Update or create metafield
          if ($meta_id) {
              // Update existing metafield
              $updateUrl = "$shopUrl/admin/api/2024-10/metafields/$meta_id.json";
              $data = [
                  'metafield' => [
                      'id' => $meta_id,
                      'value' => $metafield['value'],
                      'type' => $metafield['type'],
                  ]
              ];
  
              try {
                  $response = $client->request('PUT', $updateUrl, [
                      'headers' => [
                          'X-Shopify-Access-Token' => $accessToken,
                          'Content-Type' => 'application/json',
                      ],
                      'json' => $data
                  ]);
  
                  if ($response->getStatusCode() >= 300) {
                      throw new Exception('Error updating metafield: ' . $response->getBody()->getContents());
                  }
  
              } catch (Exception $e) {
                  error_log('Exception updating metafield: ' . $e->getMessage());
                  return ['status' => 'error', 'message' => 'Failed to update metafield: ' . $metafield['key']];
              }
  
          } else {
              // Create new metafield
              $createUrl = "$shopUrl/admin/api/2024-10/products/$product_id/metafields.json";
              $data = [
                  'metafield' => $metafield
              ];
  
              try {
                  $response = $client->request('POST', $createUrl, [
                      'headers' => [
                          'X-Shopify-Access-Token' => $accessToken,
                          'Content-Type' => 'application/json',
                      ],
                      'json' => $data
                  ]);
  
                  if ($response->getStatusCode() >= 300) {
                      throw new Exception('Error creating metafield: ' . $response->getBody()->getContents());
                  }
  
              } catch (Exception $e) {
                  error_log('Exception creating metafield: ' . $e->getMessage());
                  return ['status' => 'error', 'message' => 'Failed to create metafield: ' . $metafield['key']];
              }
          }
      }
  
      return ['status' => 'success', 'message' => 'Metafields updated or created successfully'];
    }
  
    public function find_range($range,$array_from)
    {
        $split = explode(';', $range);
        $split1 = @$split['0'];    
        $split2 = @$split['1'];
        $split1_key = array_search($split1, $array_from); 
        $split2_key = array_search($split2, $array_from);
        for ($i=$split1_key; $i <= $split2_key; $i++) { 
            $array[]=$array_from[$i];
        }
        return $array;
    }


    private function paginate($items, $perPage)
    {
        $currentPage = request()->get('page', 1); // Get the current page or default to 1

        // Slice the collection to get the items to display in current page
        $currentPageItems = array_slice($items, ($currentPage - 1) * $perPage, $perPage);

        // Create Laravel's LengthAwarePaginator instance
        return new \Illuminate\Pagination\LengthAwarePaginator(
            $currentPageItems, // Items to be paginated
            count($items),    // Total count of all items
            $perPage,         // Items per page
            $currentPage,     // Current page
            ['path' => request()->url()] // Additional paginator options
        );
    }

    function quick_detail(Request $request)
    {
      // $user_id = $this->session->userdata('user_id');
  
      // $showPrice = $this->user_model->showPrice($user_id);
      // $user_show_price = (!empty($showPrice)) ? $showPrice['0']->is_price : 0;
  
      $image_array =  $video_link = $certificate_array = [];
      $inventory_id = $request->stock_id;  
      $where = "diamond_id = '$inventory_id'"; 
        
      $query1 = "select * from tbl_diamond where " .$where;
      $records = DB::select($query1);
      // $records = $this->diamond_model->diamond_list($where);
  
      $image_array[] = $records['0']->diamond_image;
      $video_link[]=$records['0']->diamond_video;
      /*if($records['0']->report_filename!="")
      {
      if(checkLink($records['0']->report_filename)=='200'){
      $certificate_array[]=$records['0']->report_filename;
      }
      }*/
      //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      $isLogin = (!empty($user_id) && $user_show_price) ? 1 : 0;
  
      foreach ($records as $row) {
        $row->rapnet = '';
        if(!$isLogin) {        
          $row->rapnet_discount = $row->cost_carat = $row->total_price = '';
          $row->cash_price_discount = $row->cash_price = $row->cash_total_price = '';
        }
      }
      //print_ex($records);   
      $data= array(
        'records'=>$records,
        'image_array'=>$image_array,
        'certificate_array'=>$certificate_array ?? [],
        'video_link'=>$video_link,
        'isLogin' => $isLogin
      );
      echo json_encode($data);
    }

}