<?php



namespace App\Http\Controllers\Api;



use App\Http\Controllers\Controller;

use App\Models\DiamondProduct;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;

use App\Models\DiamondApi;



class DiamondProductApiController extends Controller

{

    public function index(Request $request)
    {
        $userId = 1;
    
        $products = DiamondApi::where('user_id', $userId)->get();
        $products->makeHidden(['user_id']);
    
        return response()->json([
            'success' => true,
            'data' => $products,
        ]);
    }

     public function fetchAndInsertProducts(Request $request)

    {

        $request->validate([

            'token' => 'required|string',

            'url' => 'required|url',

            'user_id' => 'required|integer',

        ]);



        $token = $request->input('token');

        $url = $request->input('url');

        $userId = $request->input('user_id');



        // Call the external API with Bearer token authorization

        $response = Http::withHeaders([

            'Authorization' => 'Bearer ' . $token,

            'Accept' => 'application/json',

        ])->get($url);



        if ($response->failed()) {

            return back()->with('error', 'Failed to fetch products: ' . $response->body());

        }

         $rawBody = $response->body();

        // Find the first "{" which is where JSON begins
        $jsonStart = strpos($rawBody, '{');
        
        if ($jsonStart === false) {
            return back()->with('error', 'No JSON found in response');
        }
        
        $validJson = substr($rawBody, $jsonStart);
        $responseData = json_decode($validJson, true);
        
        if (!isset($responseData['data']) || !is_array($responseData['data'])) {
            return back()->with('error', 'Invalid API response format');
        }
        
        $products = $responseData['data'];
//dd($products);
       


        if (!is_array($products)) {

            return back()->with('error', 'Invalid API response format');

        }

//print_r($products); die;

        // Insert or update products

        foreach ($products as $row) {

         

            DiamondProduct::updateOrCreate(

                [

                    'user_id' => $userId,

                    'stock_id' => $row['stock_id'] ?? null,

                ],

                // ['diamond_id' => $row['diamond_id'] ?? null],

                [

                    'stock_id' => isset($row['stock_id']) ? $row['stock_id'] : null,

                    'user_id' =>  $userId,

                    'availability' => isset($row['availability']) ? $row['availability'] : null,

                    'shape' => isset($row['shape']) ? $row['shape'] : null,

                    'weight' => isset($row['weight']) ? $row['weight'] : null,

                    'color' => isset($row['color']) ? $row['color'] : null,

                    'clarity' => isset($row['clarity']) ? $row['clarity'] : null,

                    'cut_grade' => isset($row['cut_grade']) ? $row['cut_grade'] : null,

                    'grade' => isset($row['grade']) ? $row['grade'] : null,

                    'cut' => isset($row['cut']) ? $row['cut'] : null,

                    'polish' => isset($row['polish']) ? $row['polish'] : null,

                    'symmetry' => isset($row['symmetry']) ? $row['symmetry'] : null,

                    'fluorescence_int' => isset($row['fluorescence_int']) ? $row['fluorescence_int'] : null,

                    'fluorescence_color' => isset($row['fluorescence_color']) ? $row['fluorescence_color'] : null,

                    'measurements' => isset($row['measurements']) ? $row['measurements'] : null,

                    'm_length' => isset($row['m_length']) ? $row['m_length'] : null,

                    'm_width' => isset($row['m_width']) ? $row['m_width'] : null,

                    'm_depth' => isset($row['m_depth']) ? $row['m_depth'] : null,

                    'lab' => isset($row['lab']) ? $row['lab'] : null,

                    'treatment' => isset($row['treatment']) ? $row['treatment'] : null,

                    'is_fancy' => isset($row['is_fancy']) ? $row['is_fancy'] : null,

                    'fancy_color' => isset($row['fancy_color']) ? $row['fancy_color'] : null,

                    'fancy_color_intensity' => isset($row['fancy_color_intensity']) ? $row['fancy_color_intensity'] : null,

                    'fancy_color_overtone' => isset($row['fancy_color_overtone']) ? $row['fancy_color_overtone'] : null,

                    'depth' => isset($row['depth']) ? $row['depth'] : null,

                    'table_d' => isset($row['table_d']) ? $row['table_d'] : null,

                    'girdle_thin' => isset($row['girdle_thin']) ? $row['girdle_thin'] : null,

                    'girdle_thick' => isset($row['girdle_thick']) ? $row['girdle_thick'] : null,

                    'girdle_perct' => isset($row['girdle_perct']) ? $row['girdle_perct'] : null,

                    'girdle_con' => isset($row['girdle_con']) ? $row['girdle_con'] : null,

                    'culet_size' => isset($row['culet_size']) ? $row['culet_size'] : null,

                    'culet_con' => isset($row['culet_con']) ? $row['culet_con'] : null,

                    'crown_ht' => isset($row['crown_ht']) ? $row['crown_ht'] : null,

                    'crown_angle' => isset($row['crown_angle']) ? $row['crown_angle'] : null,

                    'pavillion_depth' => isset($row['pavillion_depth']) ? $row['pavillion_depth'] : null,

                    'pavillion_angle' => isset($row['pavillion_angle']) ? $row['pavillion_angle'] : null,

                    'laser_inscription' => isset($row['laser_inscription']) ? $row['laser_inscription'] : null,

                    'cert_comments' => isset($row['cert_comments']) ? $row['cert_comments'] : null,

                    'country' => isset($row['country']) ? $row['country'] : null,

                    'state' => isset($row['state']) ? $row['state'] : null,

                    'city' => isset($row['city']) ? $row['city'] : null,

                    'origin' => isset($row['origin']) ? $row['origin'] : null,

                    'keytosymb' => isset($row['keytosymb']) ? $row['keytosymb'] : null,

                    'shade' => isset($row['shade']) ? $row['shade'] : null,

                    'star_len' => isset($row['star_len']) ? $row['star_len'] : null,

                    'report_dt' => isset($row['report_dt']) ? $row['report_dt'] : null,

                    'report_type' => isset($row['report_type']) ? $row['report_type'] : null,

                    'milky' => isset($row['milky']) ? $row['milky'] : null,

                    'eye_clean' => isset($row['eye_clean']) ? $row['eye_clean'] : null,

                    'gemprint_ID' => isset($row['gemprint_ID']) ? $row['gemprint_ID'] : null,

                    'BGM' => isset($row['BGM']) ? $row['BGM'] : null,

                    'ratio' => isset($row['ratio']) ? $row['ratio'] : null,

                    'diamond_type' => isset($row['diamond_type']) ? $row['diamond_type'] : null,

                    'member_comment' => isset($row['member_comment']) ? $row['member_comment'] : null,

                    'time_to_location' => isset($row['time_to_location']) ? $row['time_to_location'] : null,

                    'LsMatchedPairSeparable' => isset($row['LsMatchedPairSeparable']) ? $row['LsMatchedPairSeparable'] : null,

                    'pair_stock' => isset($row['pair_stock']) ? $row['pair_stock'] : null,

                    'allow_raplink_feed' => isset($row['allow_raplink_feed']) ? $row['allow_raplink_feed'] : null,

                    'parcel_stones' => isset($row['parcel_stones']) ? $row['parcel_stones'] : null,

                    'center_inclusion' => isset($row['center_inclusion']) ? $row['center_inclusion'] : null,

                    'black_inclusion' => isset($row['black_inclusion']) ? $row['black_inclusion'] : null,

                    'lab_location' => isset($row['lab_location']) ? $row['lab_location'] : null,

                    'brand' => isset($row['brand']) ? $row['brand'] : null,

                    'Sarine_Name' => isset($row['Sarine_Name']) ? $row['Sarine_Name'] : null,

                    'Internal_Clarity_Desc_Code' => isset($row['Internal_Clarity_Desc_Code']) ? $row['Internal_Clarity_Desc_Code'] : null,

                    'Clarity_Description' => isset($row['Clarity_Description']) ? $row['Clarity_Description'] : null,

                    'Modified_Rate' => isset($row['Modified_Rate']) ? $row['Modified_Rate'] : null,

                    'wire_discount_price' => isset($row['wire_discount_price']) ? $row['wire_discount_price'] : null,

                    'diamond_image' => isset($row['diamond_image']) ? $row['diamond_image'] : null,

                    'diamond_image_2' => isset($row['diamond_image_2']) ? $row['diamond_image_2'] : null,

                    'diamond_image_3' => isset($row['diamond_image_3']) ? $row['diamond_image_3'] : null,

                    'diamond_image_4' => isset($row['diamond_image_4']) ? $row['diamond_image_4'] : null,

                    'diamond_image_5' => isset($row['diamond_image_5']) ? $row['diamond_image_5'] : null,

                    'diamond_image_6' => isset($row['diamond_image_6']) ? $row['diamond_image_6'] : null,

                    'diamond_video' => isset($row['diamond_video']) ? $row['diamond_video'] : null,

                    'Video_HTML' => isset($row['Video_HTML']) ? $row['Video_HTML'] : null,

                    'CertificateLink' => isset($row['CertificateLink']) ? $row['CertificateLink'] : null,

                    'Rap_Price' => isset($row['Rap_Price']) ? $row['Rap_Price'] : null,

                    'Memo_Price' => isset($row['Memo_Price']) ? $row['Memo_Price'] : null,

                    'Memo_Discount_PER' => isset($row['Memo_Discount_PER']) ? $row['Memo_Discount_PER'] : null,

                    'Buy_Price' => isset($row['Buy_Price']) ? $row['Buy_Price'] : null,

                    'Buy_Price_Discount_PER' => isset($row['Buy_Price_Discount_PER']) ? $row['Buy_Price_Discount_PER'] : null,

                    'COD_Buy_Price' => isset($row['COD_Buy_Price']) ? $row['COD_Buy_Price'] : null,

                    'COD_Buy_Price_Discount_PER' => isset($row['COD_Buy_Price_Discount_PER']) ? $row['COD_Buy_Price_Discount_PER'] : null,

                    'price_per_carat' => isset($row['price_per_carat']) ? $row['price_per_carat'] : null,

                    'Certificate' => isset($row['certificate']) ? $row['certificate'] : null,

                    'cash_price' => isset($row['cash_price']) ? $row['cash_price'] : null,

                    'report_filename' => isset($row['report_filename']) ? $row['report_filename'] : null,

                    'rapnet' => isset($row['rapnet']) ? $row['rapnet'] : null,

                    'rapnet_discount' => isset($row['rapnet_discount']) ? $row['rapnet_discount'] : null,

                    'featured' => isset($row['featured']) ? $row['featured'] : null,

                    'table_open' => isset($row['table_open']) ? $row['table_open'] : null,

                    'crown_open' => isset($row['crown_open']) ? $row['crown_open'] : null,

                    'girdle_open' => isset($row['girdle_open']) ? $row['girdle_open'] : null,

                    'luster' => isset($row['luster']) ? $row['luster'] : null,

                    'type' => isset($row['type']) ? $row['type'] : null,

                    'tinge' => isset($row['tinge']) ? $row['tinge'] : null,

                    'location_of_black' => isset($row['location_of_black']) ? $row['location_of_black'] : null,

                    'table_inclusion' => isset($row['table_inclusion']) ? $row['table_inclusion'] : null,

                    'surface_graining' => isset($row['surface_graining']) ? $row['surface_graining'] : null,

                    'internal_graining' => isset($row['internal_graining']) ? $row['internal_graining'] : null,

                    'inclusion_pattern' => isset($row['inclusion_pattern']) ? $row['inclusion_pattern'] : null,

                    'diamond_origin_report' => isset($row['diamond_origin_report']) ? $row['diamond_origin_report'] : null,

                    'short_title' => isset($row['short_title']) ? $row['short_title'] : null,

                    'growth_type' => isset($row['growth_type']) ? $row['growth_type'] : null,

                    'H&A' => isset($row['H&A']) ? $row['H&A'] : null,

                    'share_access' => isset($row['share_access']) ? $row['share_access'] : null,

                    'is_upload' => isset($row['is_upload']) ? $row['is_upload'] : 0,

                    'is_update' => isset($row['is_update']) ? $row['is_update'] : 0,

                    'product_id' => isset($row['product_id']) ? $row['product_id'] : null,

                    'vendor_id' => isset($row['vendor_id']) ? $row['vendor_id'] : null,

                    'vendor_name' => isset($row['vendor_name']) ? $row['vendor_name'] : null,

                    'feed_type' => isset($row['feed_type']) ? $row['feed_type'] : null,

                ]

            );

        }


      //return response()->json(['success' => 'Products fetched successfully!']);
       return back()->with('success', 'Products fetched and inserted successfully!');

    }

}

